# scripts/audit_e0_variation.py
import os, glob, hashlib
import numpy as np
import pandas as pd

def e0_load(path):
    z = np.load(path, allow_pickle=False)
    key = "E0" if "E0" in z.files else z.files[0]
    a = z[key].astype(np.float64)
    z.close()
    return a

rows = []
for p in glob.glob(r"data\inputs\**\E0.npz", recursive=True):
    parts = p.split(os.sep)
    try:
        i = parts.index("inputs")
        gauge = parts[i+1]
        L = int(parts[i+2][1:])
        b = float(parts[i+3][1:])
        kappa = float(parts[i+4][1:])
        f = float(parts[i+5][1:])
        seed = int(parts[i+6][4:])
    except Exception:
        continue
    a = e0_load(p)
    h = hashlib.sha256(a.tobytes()).hexdigest()
    rows.append(dict(path=p, gauge=gauge, L=L, b=b, kappa=kappa, f=f, seed=seed,
                     var=float(a.var()), e0_hash=h))

df = pd.DataFrame(rows)
print("total files:", len(df))
if not df.empty:
    for (g,L), grp in df.groupby(["gauge","L"]):
        print(f"{g} L{L}: rows={len(grp)}  unique e0_hash={grp.e0_hash.nunique()}  var[min,median,max]=({grp['var'].min():.3g},{grp['var'].median():.3g},{grp['var'].max():.3g})")
    # Save a CSV if you want to inspect later
    os.makedirs("results_cc", exist_ok=True)
    df.to_csv(r"results_cc\e0_audit.csv", index=False)
